/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.IResizable;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class BasaltGiantEntity
extends PathfinderMob
implements NeutralMob,
IEntityAdditionalSpawnData,
IResizable {
    private static final UniformInt RANGED_INT = TimeUtil.m_145020_((int)20, (int)39);
    private int attackTimer;
    private int angerTime;
    private UUID angerTarget;
    private static final float BASE_ENTITY_HEIGHT = 5.0f;
    private static final float MIN_ENTITY_HEIGHT = 4.0f;
    private static final float MAX_ENTITY_HEIGHT = 6.0f;
    private static final EntityDataAccessor<Float> GIANT_SIZE = SynchedEntityData.m_135353_(BasaltGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public BasaltGiantEntity(EntityType<? extends BasaltGiantEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 2.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        float size = this.f_19796_.m_188501_();
        size /= 2.5f;
        this.setEntitySize(size += 0.8f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 56.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22278_, 30.0).m_22268_(Attributes.f_22279_, 0.45);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GIANT_SIZE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public float getEntitySize() {
        return ((Float)this.f_19804_.m_135370_(GIANT_SIZE)).floatValue();
    }

    @Override
    public void setEntitySize(float size) {
        this.m_20088_().m_135381_(GIANT_SIZE, (Object)Float.valueOf(size));
        this.m_20090_();
        this.m_6210_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Size", this.getEntitySize());
    }

    public void m_7378_(CompoundTag compound) {
        this.setEntitySize(compound.m_128457_("Size"));
        super.m_7378_(compound);
    }

    public void m_6210_() {
        super.m_6210_();
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getEntitySize());
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (GIANT_SIZE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.m_5496_((SoundEvent)IESoundEvents.BASALT_GIANT_DEATH.get(), 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        Player player;
        this.attackTimer = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        float f2 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof Player && (player = (Player)entityIn).m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            this.attackFling((Entity)player, f2 * 3.0f, 2.0);
            player.f_19864_ = true;
        }
        if (flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f1)) {
            this.attackFling(entityIn, f2, 0.6);
        }
        this.m_5496_((SoundEvent)IESoundEvents.BASALT_GIANT_HURT.get(), 1.0f, 1.0f);
        return flag;
    }

    private void attackFling(Entity entityIn, float f2, double height) {
        ((LivingEntity)entityIn).m_147240_((double)f2, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
        entityIn.m_20256_(entityIn.m_20184_().m_82520_(0.0, height, 0.0));
        this.m_19970_((LivingEntity)this, entityIn);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.SKELETON_ATTACK_GIANT.getBoolean()) {
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.GIANT_ATTACK_MAGMA_CUBE.getBoolean()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, true, false));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getEntitySize());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_19804_.m_135381_(GIANT_SIZE, (Object)Float.valueOf(buffer.readFloat()));
    }

    public int m_213860_() {
        return 73;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IESoundEvents.BASALT_GIANT_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IESoundEvents.BASALT_GIANT_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.BASALT_GIANT_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int time) {
        this.angerTime = time;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(RANGED_INT.m_214085_(this.f_19796_));
    }
}

