/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.InfernalExpansion;

public class VolineEatTable
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON_INSTANCE = new GsonBuilder().create();
    private static final Map<Item, Map<Item, Integer>> VOLINE_EAT_TABLE = new HashMap<Item, Map<Item, Integer>>();

    public VolineEatTable() {
        super(GSON_INSTANCE, "loot_tables/gameplay");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ResourceLocation resourceLocation = new ResourceLocation("infernalexp", "loot_tables/gameplay/voline_eat_table.json");
        try {
            Optional iResource = resourceManagerIn.m_213713_(resourceLocation);
            try (InputStreamReader reader = new InputStreamReader(((Resource)iResource.get()).m_215507_());){
                JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                if (jsonObject != null) {
                    for (final JsonElement entry : jsonObject.getAsJsonArray("entries")) {
                        VOLINE_EAT_TABLE.put((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getAsJsonObject().get("accepted_item").getAsString())), (Map<Item, Integer>)new HashMap<Item, Integer>(){
                            {
                                for (JsonElement item : entry.getAsJsonObject().getAsJsonArray("returned_items")) {
                                    this.put((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.getAsJsonObject().get("item").getAsString())), item.getAsJsonObject().get("amount").getAsInt());
                                }
                            }
                        });
                    }
                }
            }
            catch (IOException | RuntimeException exception) {
                InfernalExpansion.LOGGER.error("Couldn't read voline eat table list {} in data pack {}", (Object)resourceLocation, (Object)((Resource)iResource.get()).m_215506_(), (Object)exception);
            }
        }
        catch (NoSuchElementException exception) {
            InfernalExpansion.LOGGER.error("Couldn't read voline eat table from {}", (Object)resourceLocation, (Object)exception);
        }
    }

    public Map<Item, Map<Item, Integer>> getVolineEatTable() {
        return VOLINE_EAT_TABLE;
    }
}

