/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.infernalstudios.infernalexp.entities.BlindsightEntity;

public class BlindsightModel<T extends BlindsightEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("infernalexp", "blindsight"), "main");
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart backLeftLeg;
    private final ModelPart backRightLeg;

    public BlindsightModel(ModelPart root) {
        this.all = root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.backLeftLeg = this.all.m_171324_("back_left_leg");
        this.backRightLeg = this.all.m_171324_("back_right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition all = partDefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-3.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)7.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -8.0f, -12.0f, 16.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        head.m_171599_("mouth_roof", CubeListBuilder.m_171558_().m_171514_(32, 41).m_171488_(-8.0f, -8.0f, -7.0f, 16.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)-8.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("lower_jaw", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-8.0f, -1.0f, -12.0f, 16.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(4, 41).m_171488_(-8.0f, 0.0f, -12.0f, 16.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        all.m_171599_("front_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)6.0f, (float)-2.0f, (float)-3.0f));
        all.m_171599_("front_right_leg", CubeListBuilder.m_171558_().m_171514_(8, 35).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)-6.0f, (float)-2.0f, (float)-3.0f));
        all.m_171599_("back_left_leg", CubeListBuilder.m_171558_().m_171514_(44, 56).m_171480_().m_171488_(-1.0f, 0.0f, -5.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)5.0f));
        all.m_171599_("back_right_leg", CubeListBuilder.m_171558_().m_171514_(44, 56).m_171488_(-3.0f, 0.0f, -5.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)((BlindsightEntity)((Object)entityIn)).f_19797_;
        float jumpRotation = Mth.m_14031_((float)(((BlindsightEntity)((Object)entityIn)).getJumpCompletion(partialTick) * (float)Math.PI));
        this.backLeftLeg.f_104203_ = jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.backRightLeg.f_104203_ = jumpRotation * 50.0f * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.head.f_104203_ = -Mth.m_14154_((float)(Mth.m_14089_((float)(0.4662f * limbSwing)) * 1.2f * limbSwingAmount));
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.all.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

