/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import javax.annotation.CheckForNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IETags;

public class PlantedQuartzBlock
extends HorizontalBushBlock {
    protected static final VoxelShape FLOOR_SHAPE = PlantedQuartzBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    protected static final VoxelShape CEILING_SHAPE = PlantedQuartzBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape WALL_SHAPE_NORTH = PlantedQuartzBlock.m_49796_((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WALL_SHAPE_SOUTH = PlantedQuartzBlock.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0);
    protected static final VoxelShape WALL_SHAPE_EAST = PlantedQuartzBlock.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WALL_SHAPE_WEST = PlantedQuartzBlock.m_49796_((double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);

    public PlantedQuartzBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @Override
    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(IETags.Blocks.PLANTED_QUARTZ_BASE_BLOCKS);
    }

    @CheckForNull
    public BlockState getPlaceableState(Level world, BlockPos pos, Direction placeSide) {
        if (world.m_8055_(pos).m_60767_().m_76336_() && world.m_8055_(pos).m_60734_() != IEBlocks.PLANTED_QUARTZ.get()) {
            Direction attachdirection;
            if (this.isValidGround(world.m_8055_(pos.m_121945_(placeSide.m_122424_())), (BlockGetter)world, pos)) {
                attachdirection = placeSide.m_122424_();
            } else if (this.isValidGround(world.m_8055_(pos.m_121945_(placeSide)), (BlockGetter)world, pos)) {
                attachdirection = placeSide;
            } else {
                return null;
            }
            AttachFace attachface = attachdirection == Direction.UP ? AttachFace.CEILING : (attachdirection == Direction.DOWN ? AttachFace.FLOOR : AttachFace.WALL);
            if (attachface == AttachFace.WALL) {
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)attachface)).m_61124_((Property)f_54117_, (Comparable)attachdirection.m_122424_());
            }
            return (BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)attachface);
        }
        return null;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.canAttachToSurface(worldIn, pos, PlantedQuartzBlock.m_53200_((BlockState)state).m_122424_());
    }

    public boolean canAttachToSurface(LevelReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction);
        return this.isValidGround(reader.m_8055_(blockpos), (BlockGetter)reader, blockpos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case WALL: {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        return WALL_SHAPE_NORTH;
                    }
                    case SOUTH: {
                        return WALL_SHAPE_SOUTH;
                    }
                    case EAST: {
                        return WALL_SHAPE_EAST;
                    }
                }
                return WALL_SHAPE_WEST;
            }
            case FLOOR: {
                return FLOOR_SHAPE;
            }
        }
        return CEILING_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builderIn) {
        builderIn.m_61104_(new Property[]{f_54117_, f_53179_});
    }

    public Item m_5456_() {
        return Items.f_42692_;
    }
}

