/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import javax.annotation.CheckForNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IETags;

public class BuriedBoneBlock
extends HorizontalBushBlock {
    protected static final VoxelShape FLOOR_SHAPE = BuriedBoneBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    protected static final VoxelShape CEILING_SHAPE = BuriedBoneBlock.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public BuriedBoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR));
    }

    @CheckForNull
    public BlockState getPlaceableState(Level world, BlockPos pos, Direction placeSide) {
        if (world.m_8055_(pos).m_60767_().m_76336_() && world.m_8055_(pos).m_60734_() != IEBlocks.BURIED_BONE.get()) {
            Direction attachdirection;
            if (placeSide.m_122434_() != Direction.Axis.Y) {
                placeSide = Direction.UP;
            }
            if (this.isValidGround(world.m_8055_(pos.m_121945_(placeSide.m_122424_())), (BlockGetter)world, pos)) {
                attachdirection = placeSide.m_122424_();
            } else if (this.isValidGround(world.m_8055_(pos.m_121945_(placeSide)), (BlockGetter)world, pos)) {
                attachdirection = placeSide;
            } else {
                return null;
            }
            AttachFace attachface = attachdirection == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR;
            return (BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)attachface);
        }
        return null;
    }

    @Override
    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(IETags.Blocks.BURIED_BONE_BASE_BLOCKS);
    }

    public boolean canAttachToSurface(LevelReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction);
        return this.isValidGround(reader.m_8055_(blockpos), (BlockGetter)reader, blockpos);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !((AttachFace)state.m_61143_((Property)f_53179_)).equals((Object)AttachFace.WALL) && this.canAttachToSurface(worldIn, pos, BuriedBoneBlock.m_53200_((BlockState)state).m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                return FLOOR_SHAPE.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
            }
        }
        return CEILING_SHAPE.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builderIn) {
        builderIn.m_61104_(new Property[]{f_54117_, f_53179_});
    }

    public Item m_5456_() {
        return Items.f_42500_;
    }
}

