/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.data.providers;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.molybdenum.alloyed.Alloyed;
import com.molybdenum.alloyed.data.advancements.DisplayInfoBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModAdvancementProvider
implements DataProvider {
    private final DataGenerator generator;
    private static final List<NamedAdvancementBuilder> advancements = new ArrayList<NamedAdvancementBuilder>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ModAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public static void addAdvancement(NamedAdvancementBuilder advancementBuilder) {
        advancements.add(advancementBuilder);
    }

    public static List<NamedAdvancementBuilder> getAdvancements() {
        return advancements;
    }

    public static void register(DataGenerator generator) {
        generator.m_236039_(true, (DataProvider)new ModAdvancementProvider(generator));
    }

    public void m_213708_(@NotNull CachedOutput pCache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        for (NamedAdvancementBuilder advancement : advancements) {
            if (!set.add(advancement.id)) {
                throw new IllegalStateException("Duplicate advancement " + advancement.id);
            }
            Path path1 = ModAdvancementProvider.createPath(path, advancement);
            try {
                DataProvider.m_236072_((CachedOutput)pCache, (JsonElement)advancement.builder.m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                Alloyed.LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        }
    }

    private static Path createPath(Path pPath, NamedAdvancementBuilder pAdvancement) {
        return pPath.resolve("data/" + pAdvancement.id.m_135827_() + "/advancements/" + pAdvancement.id.m_135815_() + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Create: Alloyed's Advancements";
    }

    public static class NamedAdvancementBuilder {
        public String name;
        public ResourceLocation id;
        public Advancement.Builder builder;

        public NamedAdvancementBuilder(ResourceLocation id, Advancement.Builder builder, String name) {
            this.id = id;
            this.name = name;
            this.builder = builder;
        }

        public NamedAdvancementBuilder(ResourceLocation id, Advancement.Builder builder) {
            this(id, builder, id.m_135815_());
        }

        public NamedAdvancementBuilder displayInfo(Function<DisplayInfoBuilder, DisplayInfoBuilder> info) {
            DisplayInfoBuilder displayInfoBuilder = DisplayInfoBuilder.create(this.name, this);
            this.builder = this.builder.m_138358_(info.apply(displayInfoBuilder).build());
            return this;
        }

        public NamedAdvancementBuilder save() {
            ModAdvancementProvider.addAdvancement(this);
            return this;
        }
    }
}

