/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.common.registry;

import com.molybdenum.alloyed.Alloyed;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModTags {

    public static class Generic {
        public static final TagKey<Item> ZINC_INGOT = Generic.createForgeTag("ingots/zinc");
        public static final TagKey<Item> ZINC_NUGGET = Generic.createForgeTag("nuggets/zinc");
        public static final TagKey<Item> STICK = Generic.createForgeTag("rods/wooden");

        private static TagKey<Item> createForgeTag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> BRONZE_BLOCK = Blocks.createForgeTag("storage_blocks/bronze");
        public static final TagKey<Block> STEEL_BLOCK = Blocks.createForgeTag("storage_blocks/steel");
        public static final TagKey<Block> BRONZE_INSTRUMENTS = Blocks.createTag("bronze_instruments");

        private static TagKey<Block> createTag(String name) {
            return BlockTags.create((ResourceLocation)Alloyed.asResource(name));
        }

        private static TagKey<Block> createForgeTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Items {
        public static final TagKey<Item> STEEL_SHEARS = Items.createForgeTag("shears");
        public static final TagKey<Item> BRONZE_INGOT = Items.createForgeTag("ingots/bronze");
        public static final TagKey<Item> STEEL_INGOT = Items.createForgeTag("ingots/steel");
        public static final TagKey<Item> BRONZE_NUGGET = Items.createForgeTag("nuggets/bronze");
        public static final TagKey<Item> STEEL_NUGGET = Items.createForgeTag("nuggets/steel");
        public static final TagKey<Item> BRONZE_SHEET = Items.createForgeTag("plates/bronze");
        public static final TagKey<Item> STEEL_SHEET = Items.createForgeTag("plates/steel");
        public static final TagKey<Item> BRONZE_BLOCK = Items.createForgeTag("storage_blocks/bronze");
        public static final TagKey<Item> STEEL_BLOCK = Items.createForgeTag("storage_blocks/steel");
        public static final TagKey<Item> STEEL_KNIFE = Items.createForgeTag("tools/knives");
        public static final TagKey<Item> STEEL_KNIFE_FD = Items.createSpecialTag("farmersdelight", "tools/knives");
        public static final TagKey<Item> BRONZE_INSTRUMENTS = Items.createTag("bronze_instruments");

        private static TagKey<Item> createTag(String name) {
            return ItemTags.create((ResourceLocation)Alloyed.asResource(name));
        }

        private static TagKey<Item> createForgeTag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }

        private static TagKey<Item> createSpecialTag(String modId, String path) {
            return ItemTags.create((ResourceLocation)new ResourceLocation(modId, path));
        }
    }
}

