/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.common.registry;

import com.molybdenum.alloyed.Alloyed;
import com.molybdenum.alloyed.common.item.ModArmourMaterials;
import com.molybdenum.alloyed.common.item.ModItemGroup;
import com.molybdenum.alloyed.common.item.ModItemTiers;
import com.molybdenum.alloyed.common.registry.ModTags;
import com.molybdenum.alloyed.data.util.RecipeUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;

public class ModItems {
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)Alloyed.REGISTRATE.creativeModeTab(() -> ModItemGroup.MAIN_GROUP);
    public static final ItemEntry<Item> BRONZE_INGOT = ModItems.taggedIngredient("bronze_ingot", RecipeUtils.Crafting.compactingDecompactingRecipe(ModTags.Items.BRONZE_BLOCK, ModTags.Items.BRONZE_NUGGET), ModTags.Items.BRONZE_INGOT);
    public static final ItemEntry<Item> STEEL_INGOT = ModItems.taggedIngredient("steel_ingot", RecipeUtils.Crafting.compactingDecompactingRecipe(ModTags.Items.STEEL_BLOCK, ModTags.Items.STEEL_NUGGET), ModTags.Items.STEEL_INGOT);
    public static final ItemEntry<Item> BRONZE_NUGGET = ModItems.taggedIngredient("bronze_nugget", RecipeUtils.Crafting.decompactingRecipe(ModTags.Items.BRONZE_INGOT), ModTags.Items.BRONZE_NUGGET);
    public static final ItemEntry<Item> STEEL_NUGGET = ModItems.taggedIngredient("steel_nugget", RecipeUtils.Crafting.decompactingRecipe(ModTags.Items.STEEL_INGOT), ModTags.Items.STEEL_NUGGET);
    public static final ItemEntry<Item> BRONZE_SHEET = ModItems.taggedIngredient("bronze_sheet", ModTags.Items.BRONZE_SHEET);
    public static final ItemEntry<Item> STEEL_SHEET = ModItems.taggedIngredient("steel_sheet", ModTags.Items.STEEL_SHEET);
    public static final ItemEntry<SwordItem> STEEL_SWORD = ModItems.handheldItem("steel_sword", properties -> new SwordItem((Tier)ModItemTiers.STEEL, 3, -2.4f, properties), RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42383_), new TagKey[0]);
    public static final ItemEntry<PickaxeItem> STEEL_PICKAXE = ModItems.handheldItem("steel_pickaxe", properties -> new PickaxeItem((Tier)ModItemTiers.STEEL, 1, -2.8f, properties), RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42385_), new TagKey[0]);
    public static final ItemEntry<AxeItem> STEEL_AXE = ModItems.handheldItem("steel_axe", properties -> new AxeItem((Tier)ModItemTiers.STEEL, 5.0f, -3.0f, properties), RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42386_), new TagKey[0]);
    public static final ItemEntry<ShovelItem> STEEL_SHOVEL = ModItems.handheldItem("steel_shovel", properties -> new ShovelItem((Tier)ModItemTiers.STEEL, 1.5f, -3.0f, properties), RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42384_), new TagKey[0]);
    public static final ItemEntry<HoeItem> STEEL_HOE = ModItems.handheldItem("steel_hoe", properties -> new HoeItem((Tier)ModItemTiers.STEEL, -3, 0.0f, properties), RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42387_), new TagKey[0]);
    public static final ItemEntry<ShearsItem> STEEL_SHEARS = REGISTRATE.item("steel_shears", properties -> new ShearsItem(properties.m_41503_(750))).tag(new TagKey[]{ModTags.Items.STEEL_SHEARS}).recipe(RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42574_)).register();
    public static final ItemEntry<FishingRodItem> STEEL_FISHING_ROD = REGISTRATE.item("steel_fishing_rod", properties -> new FishingRodItem(properties.m_41503_(512))).model((ctx, prov) -> prov.getExistingFile(prov.modLoc("item/steel_fishing_rod"))).recipe(RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42523_)).register();
    public static final ItemEntry<ArmorItem> STEEL_HELMET = REGISTRATE.item("steel_helmet", properties -> new ArmorItem((ArmorMaterial)ModArmourMaterials.STEEL, EquipmentSlot.HEAD, properties)).recipe(RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42464_)).register();
    public static final ItemEntry<ArmorItem> STEEL_CHESTPLATE = REGISTRATE.item("steel_chestplate", properties -> new ArmorItem((ArmorMaterial)ModArmourMaterials.STEEL, EquipmentSlot.CHEST, properties)).recipe(RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42465_)).register();
    public static final ItemEntry<ArmorItem> STEEL_LEGGINGS = REGISTRATE.item("steel_leggings", properties -> new ArmorItem((ArmorMaterial)ModArmourMaterials.STEEL, EquipmentSlot.LEGS, properties)).recipe(RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42466_)).register();
    public static final ItemEntry<ArmorItem> STEEL_BOOTS = REGISTRATE.item("steel_boots", properties -> new ArmorItem((ArmorMaterial)ModArmourMaterials.STEEL, EquipmentSlot.FEET, properties)).recipe(RecipeUtils.Smithing.steelItemRecipe((ItemLike)Items.f_42467_)).register();

    public static void register() {
        Alloyed.LOGGER.debug("Registering ModItems!");
    }

    @SafeVarargs
    public static <T extends Item> ItemEntry<T> handheldItem(String name, NonNullFunction<Item.Properties, T> factory, TagKey<Item> ... tags) {
        return REGISTRATE.item(name, factory).model((ctx, prov) -> prov.handheld(() -> ((DataGenContext)ctx).getEntry(), prov.modLoc("item/" + name))).tag(tags).register();
    }

    @SafeVarargs
    public static <T extends Item> ItemEntry<T> handheldItem(String name, NonNullFunction<Item.Properties, T> factory, NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> recipe, TagKey<Item> ... tags) {
        return REGISTRATE.item(name, factory).model((ctx, prov) -> prov.handheld(() -> ((DataGenContext)ctx).getEntry(), prov.modLoc("item/" + name))).tag(tags).recipe(recipe).register();
    }

    @SafeVarargs
    private static ItemEntry<Item> taggedIngredient(String name, TagKey<Item> ... tags) {
        return REGISTRATE.item(name, Item::new).tag(tags).register();
    }

    @SafeVarargs
    private static ItemEntry<Item> taggedIngredient(String name, NonNullBiConsumer<DataGenContext<Item, Item>, RegistrateRecipeProvider> recipe, TagKey<Item> ... tags) {
        return REGISTRATE.item(name, Item::new).tag(tags).recipe(recipe).register();
    }
}

