/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.common.content.blocks;

import com.molybdenum.alloyed.client.registry.ModSoundEvents;
import com.simibubi.create.AllItems;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BronzeBellBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final IntegerProperty NOTE = BlockStateProperties.f_61424_;

    public BronzeBellBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NOTE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{POWERED, NOTE});
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean isPowered = pLevel.m_46753_(pPos);
        if (isPowered != (Boolean)pState.m_61143_((Property)POWERED)) {
            if (isPowered) {
                this.attemptToRing(pLevel, pPos);
            }
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        Entity entity = pProjectile.m_37282_();
        Player player = entity instanceof Player ? (Player)entity : null;
        this.onHit(pLevel, pHit, player, true);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AllItems.WRENCH.isIn(pPlayer.m_21120_(pHand))) {
            pState = (BlockState)pState.m_61122_((Property)NOTE);
            pLevel.m_7731_(pPos, pState, 3);
        }
        return this.onHit(pLevel, pHit, pPlayer, true) ? InteractionResult.m_19078_((boolean)pLevel.f_46443_) : InteractionResult.PASS;
    }

    public boolean onHit(Level pLevel, BlockHitResult pResult, @Nullable Player pPlayer, boolean pCanRingBell) {
        boolean canRing;
        Direction direction = pResult.m_82434_();
        BlockPos blockpos = pResult.m_82425_();
        boolean bl = canRing = !pCanRingBell || this.isProperHit(direction);
        if (canRing) {
            this.attemptToRing(pLevel, blockpos);
            if (pPlayer != null) {
                pPlayer.m_36220_(Stats.f_12979_);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(Direction pDirection) {
        return pDirection.m_122434_() != Direction.Axis.Y;
    }

    public void attemptToRing(Level pLevel, BlockPos pPos) {
        pLevel.m_7696_(pPos, (Block)this, 0, 0);
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        int i = (Integer)pState.m_61143_((Property)NOTE);
        float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
        pLevel.m_5594_(null, pPos, (SoundEvent)ModSoundEvents.BRONZE_BELL.get(), SoundSource.RECORDS, 5.0f, f);
        return true;
    }
}

