/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.packets;

import com.rolfmao.upgradednetherite.handlers.PlayerFallDistanceUpdateHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketPlayerFallDistanceUpdate {
    private final UUID player;
    private final Float fallDistance;

    public PacketPlayerFallDistanceUpdate(UUID player, Float fallDistance) {
        this.player = player;
        this.fallDistance = fallDistance;
    }

    public static void encode(PacketPlayerFallDistanceUpdate msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.player);
        buf.writeFloat(msg.fallDistance.floatValue());
    }

    public static PacketPlayerFallDistanceUpdate decode(FriendlyByteBuf buf) {
        UUID player = buf.m_130259_();
        Float fallDistance = Float.valueOf(buf.readFloat());
        return new PacketPlayerFallDistanceUpdate(player, fallDistance);
    }

    public static void handle(PacketPlayerFallDistanceUpdate msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Float fallDistance = msg.fallDistance;
            PlayerFallDistanceUpdateHandler.handlePlayerFallDistanceUpdate(player, fallDistance);
        });
        ctx.get().setPacketHandled(true);
    }
}

