/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.utils.ToolUtil;
import com.rolfmao.upgradednetherite.utils.check.EnderUtil;
import com.rolfmao.upgradednetherite.utils.check.FireUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.annotations.NotNull;

public class GlobalLootModifiers {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"upgradednetherite");
    private static final RegistryObject<Codec<AutoSmeltModifier>> AUTOSMELT_MODIFIER = GLM.register("auto_smelt_tool", AutoSmeltModifier.CODEC);
    private static final RegistryObject<Codec<EnderTeleportModifier>> ENDERTP_MODIFIER = GLM.register("ender_teleport_tool", EnderTeleportModifier.CODEC);

    private static class AutoSmeltModifier
    extends LootModifier {
        public static final Supplier<Codec<AutoSmeltModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AutoSmeltModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AutoSmeltModifier::new)));

        public AutoSmeltModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            Entity killer = (Entity)context.m_78953_(LootContextParams.f_81459_);
            Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
            BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
            Player player = null;
            Projectile arrow = null;
            if (entity instanceof Player) {
                player = (Player)entity;
            }
            if (player == null && killer instanceof Player) {
                player = (Player)killer;
            }
            if (killer instanceof Projectile) {
                arrow = (Projectile)killer;
            }
            ObjectArrayList itemStackList = new ObjectArrayList();
            if (blockState != null && player != null && player.m_6047_()) {
                return generatedLoot;
            }
            if (!UpgradedNetheriteConfig.EnableAutoSmelt || tool != null && ToolUtil.getDisableEffect(tool)) {
                return generatedLoot;
            }
            if (player != null && FireUtil.isFireToolOrWeapon(player.m_21205_()) && !ToolUtil.getDisableEffect(player.m_21205_()) || arrow != null && !arrow.m_19880_().isEmpty() && FireUtil.isFireProjectile(arrow)) {
                if (tool != null) {
                    Integer FortuneLevel = 0;
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)tool);
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.f_44987_)) {
                        FortuneLevel = (Integer)enchantments.get(Enchantments.f_44987_);
                    }
                    Integer finalFortuneLevel = FortuneLevel;
                    generatedLoot.forEach(stack -> itemStackList.add((Object)this.autoSmelt((ItemStack)stack, (Level)context.m_78952_(), finalFortuneLevel)));
                } else {
                    generatedLoot.forEach(stack -> itemStackList.add((Object)this.autoSmelt((ItemStack)stack, (Level)context.m_78952_(), 0)));
                }
                return itemStackList;
            }
            return generatedLoot;
        }

        protected ItemStack autoSmelt(ItemStack stack, Level level, Integer fortuneLevel) {
            Double rand;
            Integer countBonus = 0;
            Optional<ItemStack> iStackSmelt = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), level).map(AbstractCookingRecipe::m_8043_).filter(itemStack -> !itemStack.m_41619_());
            if (UpgradedNetheriteConfig.EnableAutoSmeltFortune && fortuneLevel > 0 && (stack.toString().contains("ore") && iStackSmelt.toString().contains("ingot") || stack.toString().contains("log") && iStackSmelt.toString().contains("charcoal")) && fortuneLevel > 0 && (rand = Double.valueOf(Math.random())) >= (double)(2 / (fortuneLevel + 2))) {
                Integer randI;
                countBonus = randI = Integer.valueOf((int)(Math.random() * (double)(fortuneLevel + 1)));
            }
            Integer finalCountBonus = countBonus;
            return iStackSmelt.map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * (itemStack.m_41613_() * (1 + finalCountBonus))))).orElse(stack);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class EnderTeleportModifier
    extends LootModifier {
        public static final Supplier<Codec<EnderTeleportModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> EnderTeleportModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, EnderTeleportModifier::new)));

        public EnderTeleportModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            Entity killer = (Entity)context.m_78953_(LootContextParams.f_81459_);
            Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
            BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
            Projectile arrow = null;
            Player player = null;
            if (blockState != null && entity instanceof Player) {
                player = (Player)entity;
            } else if (blockState == null && killer instanceof Player) {
                player = (Player)killer;
            } else if (blockState == null && killer instanceof Projectile) {
                arrow = (Projectile)killer;
            }
            if (player != null && UpgradedNetheriteConfig.EnableTeleportChest) {
                ItemStack heldItem = player.m_21205_();
                if (EnderUtil.isEnderToolOrWeapon(player.m_21205_()) && !ToolUtil.getDisableEffect(heldItem) && heldItem.m_41783_() != null && heldItem.m_41783_().m_128441_("UpgradedNetherite_Tagged") && heldItem.m_41783_().m_128471_("UpgradedNetherite_Tagged")) {
                    IItemHandler iItemHandler;
                    BlockEntity blockEntity;
                    Level level = player.f_19853_;
                    String levelPath = level.m_46472_().m_135782_().m_135815_();
                    if (!levelPath.equals(heldItem.m_41783_().m_128461_("UpgradedNetherite_Dimension"))) {
                        return generatedLoot;
                    }
                    BlockPos blockPos = new BlockPos(heldItem.m_41783_().m_128465_("UpgradedNetherite_Position")[0], heldItem.m_41783_().m_128465_("UpgradedNetherite_Position")[1], heldItem.m_41783_().m_128465_("UpgradedNetherite_Position")[2]);
                    BlockState state = level.m_8055_(blockPos);
                    if (state.m_155947_() && (blockEntity = level.m_7702_(blockPos)) != null && (iItemHandler = (IItemHandler)((ImmutablePair)blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(capability -> ImmutablePair.of((Object)capability, (Object)blockEntity)).get()).getKey()) != null) {
                        ObjectArrayList itemStackList = new ObjectArrayList();
                        IItemHandler finalIItemHandler = iItemHandler;
                        generatedLoot.forEach(stack -> itemStackList.add((Object)ItemHandlerHelper.insertItemStacked((IItemHandler)finalIItemHandler, (ItemStack)stack, (boolean)false)));
                        return itemStackList;
                    }
                }
            } else if (arrow != null && UpgradedNetheriteConfig.EnableTeleportChest && EnderUtil.isEnderProjectile(arrow) && arrow.getPersistentData().m_128471_("UpgradedNetherite_Tagged")) {
                IItemHandler iItemHandler;
                BlockEntity blockEntity;
                Level level = arrow.f_19853_;
                String levelPath = level.m_46472_().m_135782_().m_135815_();
                if (!levelPath.equals(arrow.getPersistentData().m_128461_("UpgradedNetherite_Dimension"))) {
                    return generatedLoot;
                }
                BlockPos blockPos = new BlockPos(arrow.getPersistentData().m_128465_("UpgradedNetherite_Position")[0], arrow.getPersistentData().m_128465_("UpgradedNetherite_Position")[1], arrow.getPersistentData().m_128465_("UpgradedNetherite_Position")[2]);
                BlockState state = level.m_8055_(blockPos);
                if (state.m_155947_() && (blockEntity = level.m_7702_(blockPos)) != null && (iItemHandler = (IItemHandler)((ImmutablePair)blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(capability -> ImmutablePair.of((Object)capability, (Object)blockEntity)).get()).getKey()) != null) {
                    ObjectArrayList itemStackList = new ObjectArrayList();
                    IItemHandler finalIItemHandler = iItemHandler;
                    generatedLoot.forEach(stack -> itemStackList.add((Object)ItemHandlerHelper.insertItemStacked((IItemHandler)finalIItemHandler, (ItemStack)stack, (boolean)false)));
                    return itemStackList;
                }
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

