/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.common.blocks;

import chappie.displaycase.common.criterions.PaintItemTrigger;
import chappie.displaycase.common.criterions.PutItemInDisplayCaseTrigger;
import chappie.displaycase.common.tile.DisplayCaseTileEntity;
import chappie.displaycase.common.tile.ModTileEntities;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DisplayCaseBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE = Stream.of(Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.875, (double)14.024999999999988, (double)8.0, (double)9.125, (double)15.524999999999988, (double)8.0), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.5, (double)13.424999999999994, (double)6.5, (double)9.5, (double)14.17499999999999, (double)9.5), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.5625, (double)12.587499999999991, (double)6.5625, (double)9.4375, (double)13.212499999999988, (double)9.4375), (VoxelShape)Block.m_49796_((double)8.0, (double)14.024999999999988, (double)6.875, (double)8.0, (double)15.524999999999988, (double)9.125), (BooleanOp)BooleanOp.f_82689_), (BooleanOp)BooleanOp.f_82689_), (BooleanOp)BooleanOp.f_82689_), Block.m_49796_((double)1.875, (double)1.2249999999999992, (double)1.875, (double)14.125, (double)13.47499999999999, (double)14.125), Block.m_49796_((double)2.0, (double)4.163336342344337E-17, (double)2.0, (double)14.0, (double)1.5, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DisplayCaseBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.5f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.MAIN_HAND && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof DisplayCaseTileEntity) {
                DisplayCaseTileEntity tile = (DisplayCaseTileEntity)blockEntity;
                ItemStack stack = player.m_21120_(hand);
                if (!stack.m_41619_()) {
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
                    if (tile.getItem().m_41619_()) {
                        ItemStack stack1 = stack.m_41777_();
                        if (tile.setItem(stack1)) {
                            if (!player.m_150110_().f_35937_) {
                                stack.m_41774_(1);
                            }
                            PutItemInDisplayCaseTrigger.INSTANCE.trigger(player, stack1);
                            return InteractionResult.CONSUME;
                        }
                        return InteractionResult.FAIL;
                    }
                    Item item = stack.m_41720_();
                    if (item instanceof DyeItem) {
                        DyeItem item2 = (DyeItem)item;
                        if (tile.getColor() != item2.m_41089_()) {
                            PaintItemTrigger.INSTANCE.trigger(serverPlayer);
                            tile.setColor(item2.m_41089_());
                            if (!player.m_150110_().f_35937_) {
                                stack.m_41774_(1);
                            }
                            level.m_5594_(player, pos, SoundEvents.f_144091_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            return InteractionResult.CONSUME;
                        }
                    }
                    if (tile.getColor() != null && stack.m_41720_() == Items.f_42447_) {
                        tile.setColor(null);
                        if (!player.m_150110_().f_35937_) {
                            player.m_21008_(hand, Items.f_42446_.m_7968_());
                        }
                        level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
                        return InteractionResult.CONSUME;
                    }
                    if (tile.isWaxed()) {
                        if (stack.m_41720_() instanceof AxeItem) {
                            level.m_5594_(null, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            level.m_5898_(null, 3004, pos, 0);
                            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
                            tile.setWaxed(false);
                            if (level.f_46441_.m_188501_() < 0.1f) {
                                level.m_46953_(pos, false, (Entity)player);
                            }
                            return InteractionResult.CONSUME;
                        }
                    } else if (stack.m_41720_() instanceof HoneycombItem) {
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        level.m_5898_(null, 3003, pos, 0);
                        tile.setWaxed(true);
                        return InteractionResult.CONSUME;
                    }
                }
                if (!tile.getItem().m_41619_()) {
                    if (!player.m_150110_().f_35937_) {
                        player.m_36356_(tile.getItem());
                    }
                    tile.setItem(ItemStack.f_41583_);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(world, pos, state);
        world.m_141902_(pos, ModTileEntities.DISPLAY_CASE).ifPresent(tile -> tile.m_187476_(itemstack));
        return itemstack;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor accessor, BlockPos pos, BlockPos pos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return super.m_7417_(state, direction, state1, accessor, pos, pos1);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        if (state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public float m_7749_(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DisplayCaseTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return DisplayCaseBlock.m_152132_(type, ModTileEntities.DISPLAY_CASE, DisplayCaseTileEntity::tick);
    }
}

