/*
 * Decompiled with CFR 0.152.
 */
package net.mde.dungeons;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mde.dungeons.init.DuneonsModBiomes;
import net.mde.dungeons.init.DuneonsModBlockEntities;
import net.mde.dungeons.init.DuneonsModBlocks;
import net.mde.dungeons.init.DuneonsModEntities;
import net.mde.dungeons.init.DuneonsModFeatures;
import net.mde.dungeons.init.DuneonsModFluidTypes;
import net.mde.dungeons.init.DuneonsModFluids;
import net.mde.dungeons.init.DuneonsModItems;
import net.mde.dungeons.init.DuneonsModMenus;
import net.mde.dungeons.init.DuneonsModMobEffects;
import net.mde.dungeons.init.DuneonsModPaintings;
import net.mde.dungeons.init.DuneonsModParticleTypes;
import net.mde.dungeons.init.DuneonsModSounds;
import net.mde.dungeons.init.DuneonsModTabs;
import net.mde.dungeons.init.DuneonsModVillagerProfessions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="duneons")
public class DuneonsMod {
    public static final Logger LOGGER = LogManager.getLogger(DuneonsMod.class);
    public static final String MODID = "duneons";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("duneons", "duneons"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public DuneonsMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        DuneonsModTabs.load();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DuneonsModSounds.REGISTRY.register(bus);
        DuneonsModBlocks.REGISTRY.register(bus);
        DuneonsModItems.REGISTRY.register(bus);
        DuneonsModEntities.REGISTRY.register(bus);
        DuneonsModBlockEntities.REGISTRY.register(bus);
        DuneonsModFeatures.REGISTRY.register(bus);
        DuneonsModFluids.REGISTRY.register(bus);
        DuneonsModFluidTypes.REGISTRY.register(bus);
        DuneonsModPaintings.REGISTRY.register(bus);
        DuneonsModMobEffects.REGISTRY.register(bus);
        DuneonsModParticleTypes.REGISTRY.register(bus);
        DuneonsModMenus.REGISTRY.register(bus);
        DuneonsModBiomes.REGISTRY.register(bus);
        DuneonsModVillagerProfessions.PROFESSIONS.register(bus);
        GeckoLib.initialize();
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

