/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin.instancemanage;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(targets={"me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData$Builder"}, remap=false)
public class SodiumChunkRenderDataMixin {
    @Unique
    private List<BlockEntity> flywheel$blockEntities;
    @Unique
    private Level flywheel$level;

    @Inject(method={"addBlockEntity"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void flywheel$onAddBlockEntity(BlockEntity be, boolean cull, CallbackInfo ci) {
        if (this.flywheel$level == null) {
            this.flywheel$level = be.m_58904_();
        }
        if (!Backend.canUseInstancing(this.flywheel$level)) {
            return;
        }
        if (InstancedRenderRegistry.canInstance(be.m_58903_())) {
            if (this.flywheel$blockEntities == null) {
                this.flywheel$blockEntities = new ArrayList<BlockEntity>();
            }
            this.flywheel$blockEntities.add(be);
        }
        if (InstancedRenderRegistry.shouldSkipRender(be)) {
            ci.cancel();
        }
    }

    @Inject(method={"build"}, at={@At(value="HEAD")})
    private void flywheel$onBuild(CallbackInfoReturnable<ChunkRenderData> cir) {
        if (this.flywheel$level == null || this.flywheel$blockEntities == null || !Backend.canUseInstancing(this.flywheel$level)) {
            return;
        }
        InstancedRenderDispatcher.getBlockEntities((LevelAccessor)this.flywheel$level).queueAddAll(this.flywheel$blockEntities);
    }
}

