/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.core.Templates;
import com.jozufozu.flywheel.core.compile.FragmentCompiler;
import com.jozufozu.flywheel.core.compile.Memoizer;
import com.jozufozu.flywheel.core.compile.ProgramAssembler;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexCompiler;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.source.FileResolution;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import java.util.ArrayList;
import java.util.List;

public class ProgramCompiler<P extends GlProgram>
extends Memoizer<ProgramContext, P> {
    private static final List<ProgramCompiler<?>> ALL_COMPILERS = new ArrayList();
    private final GlProgram.Factory<P> factory;
    private final VertexCompiler vertexCompiler;
    private final FragmentCompiler fragmentCompiler;

    public ProgramCompiler(GlProgram.Factory<P> factory, VertexCompiler vertexCompiler, FragmentCompiler fragmentCompiler) {
        this.factory = factory;
        this.vertexCompiler = vertexCompiler;
        this.fragmentCompiler = fragmentCompiler;
        ALL_COMPILERS.add(this);
    }

    public static <T extends VertexData, P extends GlProgram> ProgramCompiler<P> create(Template<T> template, GlProgram.Factory<P> factory, FileResolution header) {
        return new ProgramCompiler<P>(factory, new VertexCompiler(template, header), new FragmentCompiler(Templates.FRAGMENT, header));
    }

    public P getProgram(ProgramContext ctx) {
        return (P)((GlProgram)super.get(ctx));
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.vertexCompiler.invalidate();
        this.fragmentCompiler.invalidate();
    }

    @Override
    protected P _create(ProgramContext ctx) {
        return new ProgramAssembler(ctx.spec.name).attachShader((GlShader)this.vertexCompiler.get(new VertexCompiler.Context(ctx.spec.getVertexFile(), ctx.ctx, ctx.vertexType))).attachShader((GlShader)this.fragmentCompiler.get(new FragmentCompiler.Context(ctx.spec.getFragmentFile(), ctx.ctx, ctx.alphaDiscard))).link().build(this.factory);
    }

    @Override
    protected void _destroy(P value) {
        ((GlObject)value).delete();
    }

    public static void invalidateAll(ReloadRenderersEvent event) {
        ALL_COMPILERS.forEach(ProgramCompiler::invalidate);
    }
}

