/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.struct;

import com.jozufozu.flywheel.api.struct.StructType;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import com.jozufozu.flywheel.backend.struct.BufferWriter;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public abstract class UnsafeBufferWriter<S>
extends BufferWriter<S> {
    protected long writePointer;

    protected UnsafeBufferWriter(VecBuffer backingBuffer, StructType<S> vertexType) {
        super(backingBuffer, vertexType);
        this.acquireWritePointer();
    }

    @Override
    public void seek(int pos) {
        super.seek(pos);
        this.acquireWritePointer();
    }

    @Override
    protected void advance() {
        this.writePointer += (long)this.stride;
    }

    private void acquireWritePointer() {
        this.writePointer = MemoryUtil.memAddress((ByteBuffer)this.backingBuffer.unwrap(), (int)this.backingBuffer.position());
    }
}

