/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.klikli_dev.forgebrainlib.api.core.BrainActivityGroup;
import com.klikli_dev.forgebrainlib.api.core.SmartBrain;
import com.klikli_dev.forgebrainlib.api.core.behaviour.GroupBehaviour;
import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.object.BrainBehaviourConsumer;
import com.klikli_dev.forgebrainlib.object.BrainBehaviourPredicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import org.jetbrains.annotations.Nullable;

public final class BrainUtils {
    public static <T> T memoryOrDefault(LivingEntity entity, MemoryModuleType<T> memory, Supplier<T> fallback) {
        return BrainUtils.memoryOrDefault(entity.m_6274_(), memory, fallback);
    }

    public static <T> T memoryOrDefault(Brain<?> brain, MemoryModuleType<T> memory, Supplier<T> fallback) {
        return brain.m_21952_(memory).orElseGet(fallback);
    }

    @Nullable
    public static <T> T getMemory(LivingEntity entity, MemoryModuleType<T> memory) {
        return BrainUtils.getMemory(entity.m_6274_(), memory);
    }

    @Nullable
    public static <T> T getMemory(Brain<?> brain, MemoryModuleType<T> memory) {
        return (T)BrainUtils.memoryOrDefault(brain, memory, () -> null);
    }

    public static <T> void withMemory(LivingEntity entity, MemoryModuleType<T> memory, Consumer<T> consumer) {
        BrainUtils.withMemory(entity.m_6274_(), memory, consumer);
    }

    public static <T> void withMemory(Brain<?> brain, MemoryModuleType<T> memory, Consumer<T> consumer) {
        brain.m_21952_(memory).ifPresent(consumer);
    }

    public static boolean hasMemory(LivingEntity entity, MemoryModuleType<?> memory) {
        return BrainUtils.hasMemory(entity.m_6274_(), memory);
    }

    public static boolean hasMemory(Brain<?> brain, MemoryModuleType<?> memory) {
        return brain.m_21874_(memory);
    }

    public static long getTimeUntilMemoryExpires(LivingEntity entity, MemoryModuleType<?> memory) {
        return BrainUtils.getTimeUntilMemoryExpires(entity.m_6274_(), memory);
    }

    public static long getTimeUntilMemoryExpires(Brain<?> brain, MemoryModuleType<?> memory) {
        return brain.m_147341_(memory);
    }

    public static <T> void setMemory(LivingEntity entity, MemoryModuleType<T> memoryType, T memory) {
        BrainUtils.setMemory(entity.m_6274_(), memoryType, memory);
    }

    public static <T> void setMemory(Brain<?> brain, MemoryModuleType<T> memoryType, T memory) {
        brain.m_21879_(memoryType, memory);
    }

    public static <T> void setForgettableMemory(LivingEntity entity, MemoryModuleType<T> memoryType, T memory, int expirationTicks) {
        BrainUtils.setForgettableMemory(entity.m_6274_(), memoryType, memory, expirationTicks);
    }

    public static <T> void setForgettableMemory(Brain<?> brain, MemoryModuleType<T> memoryType, T memory, int expirationTicks) {
        brain.m_21882_(memoryType, memory, (long)expirationTicks);
    }

    public static void clearMemory(LivingEntity entity, MemoryModuleType<?> memory) {
        BrainUtils.clearMemory(entity.m_6274_(), memory);
    }

    public static void clearMemory(Brain<?> brain, MemoryModuleType<?> memory) {
        brain.m_21936_(memory);
    }

    public static void clearMemories(LivingEntity entity, MemoryModuleType<?> ... memories) {
        BrainUtils.clearMemories(entity.m_6274_(), memories);
    }

    public static void clearMemories(Brain<?> brain, MemoryModuleType<?> ... memories) {
        for (MemoryModuleType<?> memory : memories) {
            brain.m_21936_(memory);
        }
    }

    @Nullable
    public static LivingEntity getTargetOfEntity(LivingEntity entity) {
        return BrainUtils.getTargetOfEntity(entity, null);
    }

    @Nullable
    public static LivingEntity getTargetOfEntity(LivingEntity entity, @Nullable LivingEntity fallback) {
        return BrainUtils.memoryOrDefault(entity.m_6274_(), MemoryModuleType.f_26372_, () -> fallback);
    }

    @Nullable
    public static LivingEntity getLastAttacker(LivingEntity entity) {
        return (LivingEntity)BrainUtils.memoryOrDefault(entity, MemoryModuleType.f_26382_, null);
    }

    public static void setTargetOfEntity(LivingEntity entity, @Nullable LivingEntity target) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6710_(target);
        }
        if (target == null) {
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26372_);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.f_26372_, target);
        }
    }

    public static boolean canSee(LivingEntity entity, LivingEntity target) {
        Brain brain = entity.m_6274_();
        if (BehaviorUtils.m_22636_((Brain)brain, (LivingEntity)target)) {
            return true;
        }
        return entity.m_142582_((Entity)target);
    }

    public static Stream<Behavior<?>> getAllBehaviours(Brain<?> brain) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            return smartBrain.getBehaviours();
        }
        return brain.f_21845_.values().stream().map(Map::values).flatMap(set -> set.stream().map(value -> value.stream().toList()).flatMap(Collection::stream));
    }

    public static void forEachBehaviour(Brain<?> brain, BrainBehaviourConsumer consumer) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            smartBrain.forEachBehaviour(consumer);
            return;
        }
        Set behaviours = brain.f_21845_.entrySet();
        for (Map.Entry priorityEntry : behaviours) {
            Integer priority = (Integer)priorityEntry.getKey();
            for (Map.Entry activityEntry : ((Map)priorityEntry.getValue()).entrySet()) {
                Activity activity = (Activity)activityEntry.getKey();
                for (Behavior behaviour : (Set)activityEntry.getValue()) {
                    BrainUtils.consumeBehaviour(priority, activity, behaviour, null, consumer);
                }
            }
        }
    }

    private static <E extends LivingEntity> void consumeBehaviour(int priority, Activity activity, Behavior<E> behaviour, @Nullable Behavior<E> parentBehaviour, BrainBehaviourConsumer consumer) {
        consumer.consume(priority, activity, behaviour, parentBehaviour);
        if (behaviour instanceof GateBehavior) {
            GateBehavior groupBehaviour = (GateBehavior)behaviour;
            groupBehaviour.f_22871_.m_147932_().forEach(childBehaviour -> BrainUtils.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            groupBehaviour.getBehaviours().forEachRemaining(childBehaviour -> BrainUtils.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        }
    }

    public static <E extends LivingEntity> void removeBehaviour(E entity, BrainBehaviourPredicate predicate) {
        Brain brain = entity.m_6274_();
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            smartBrain.removeBehaviour(entity, predicate);
            return;
        }
        Set behaviours = entity.m_6274_().f_21845_.entrySet();
        for (Map.Entry entry : behaviours) {
            Integer priority = (Integer)entry.getKey();
            for (Map.Entry activityEntry : ((Map)entry.getValue()).entrySet()) {
                Activity activity = (Activity)activityEntry.getKey();
                Iterator iterator = ((Set)activityEntry.getValue()).iterator();
                while (iterator.hasNext()) {
                    Behavior behaviour = (Behavior)iterator.next();
                    BrainUtils.checkBehaviour(priority, activity, behaviour, null, predicate, () -> {
                        if (behaviour.m_22536_() == Behavior.Status.RUNNING) {
                            behaviour.m_22562_((ServerLevel)entity.m_9236_(), entity, entity.f_19853_.m_46467_());
                        }
                        iterator.remove();
                    });
                }
            }
        }
    }

    private static <E extends LivingEntity> void checkBehaviour(int priority, Activity activity, Behavior<E> behaviour, @Nullable Behavior<E> parentBehaviour, BrainBehaviourPredicate predicate, Runnable callback) {
        if (predicate.isBehaviour(priority, activity, behaviour, parentBehaviour)) {
            callback.run();
        } else if (behaviour instanceof GateBehavior) {
            GateBehavior groupBehaviour = (GateBehavior)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.f_22871_.m_147932_().iterator();
            while (childBehaviourIterator.hasNext()) {
                BrainUtils.checkBehaviour(priority, activity, (Behavior)childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.f_22871_.m_147932_().iterator().hasNext()) {
                callback.run();
            }
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.getBehaviours();
            while (childBehaviourIterator.hasNext()) {
                BrainUtils.checkBehaviour(priority, activity, childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.getBehaviours().hasNext()) {
                callback.run();
            }
        }
    }

    public static void addBehaviour(Brain<?> brain, int priority, Activity activity, Behavior behaviourControl) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            smartBrain.addBehaviour(priority, activity, behaviourControl);
            return;
        }
        brain.f_21845_.computeIfAbsent(priority, priority2 -> Maps.newHashMap()).computeIfAbsent(activity, activity2 -> Sets.newLinkedHashSet()).add(behaviourControl);
        for (Object memoryType : behaviourControl.f_22522_.keySet()) {
            brain.f_21843_.putIfAbsent((MemoryModuleType)memoryType, Optional.empty());
        }
    }

    public static void addActivity(Brain<?> brain, BrainActivityGroup<?> behaviourGroup) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            smartBrain.addActivity(behaviourGroup);
            return;
        }
        brain.m_21907_(behaviourGroup.getActivity(), behaviourGroup.pairBehaviourPriorities(), behaviourGroup.getActivityStartMemoryConditions(), behaviourGroup.getWipedMemoriesOnFinish());
    }

    public static <S extends Sensor<?>> void addSensor(Brain<?> brain, SensorType<S> sensorType, S sensor) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            if (!(sensor instanceof ExtendedSensor)) {
                throw new IllegalArgumentException("Attempted to provide sensor to SmartBrain, only ExtendedSensor subclasses acceptable. Sensor: " + sensor.getClass());
            }
            ExtendedSensor extendedSensor = (ExtendedSensor)sensor;
            smartBrain.addSensor(extendedSensor);
            return;
        }
        brain.f_21844_.put(sensorType, sensor);
        BrainUtils.addMemories(brain, sensor.m_7163_().toArray(new MemoryModuleType[0]));
    }

    public static void addMemories(Brain<?> brain, MemoryModuleType<?> ... memories) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            for (MemoryModuleType<?> memoryType : memories) {
                smartBrain.m_21952_(memoryType);
            }
            return;
        }
        for (MemoryModuleType<?> memoryType : memories) {
            brain.f_21843_.computeIfAbsent(memoryType, key -> Optional.empty()).map(ExpirableValue::m_26319_);
        }
    }
}

