/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.example;

import com.klikli_dev.forgebrainlib.api.SmartBrainOwner;
import com.klikli_dev.forgebrainlib.api.core.BrainActivityGroup;
import com.klikli_dev.forgebrainlib.api.core.SmartBrainProvider;
import com.klikli_dev.forgebrainlib.api.core.behaviour.FirstApplicableBehaviour;
import com.klikli_dev.forgebrainlib.api.core.behaviour.OneRandomBehaviour;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.attack.BowAttack;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.misc.AvoidSun;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.misc.Idle;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.move.AvoidEntity;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.move.EscapeSun;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.move.StrafeTarget;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import com.klikli_dev.forgebrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import com.klikli_dev.forgebrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.Level;

public class SBLSkeleton
extends Skeleton
implements SmartBrainOwner<SBLSkeleton> {
    public SBLSkeleton(EntityType<? extends SBLSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    protected final void m_8099_() {
    }

    public final void m_32164_() {
    }

    protected Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider<SBLSkeleton>(this);
    }

    @Override
    public List<ExtendedSensor<SBLSkeleton>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor<SBLSkeleton>().setPredicate((target, entity) -> {
            Turtle turtle;
            return target instanceof Player || target instanceof IronGolem || target instanceof Wolf || target instanceof Turtle && (turtle = (Turtle)target).m_6162_() && !turtle.m_20069_();
        })});
    }

    @Override
    public BrainActivityGroup<SBLSkeleton> getCoreTasks() {
        return BrainActivityGroup.coreTasks(new Behavior[]{new AvoidSun(), new EscapeSun<PathfinderMob>().cooldownFor(entity -> 20), new AvoidEntity().avoiding(entity -> entity instanceof Wolf), new LookAtTargetSink(40, 300), new StrafeTarget<PathfinderMob>().stopStrafingWhen(entity -> !SBLSkeleton.isHoldingBow((LivingEntity)entity)).startCondition(SBLSkeleton::isHoldingBow), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<SBLSkeleton> getIdleTasks() {
        return BrainActivityGroup.idleTasks(new FirstApplicableBehaviour(new TargetOrRetaliate(), new SetPlayerLookTarget(), new SetRandomLookTarget()), new OneRandomBehaviour(new SetRandomWalkTarget().speedModifier(1.0f), new Idle<LivingEntity>().runFor(entity -> entity.m_217043_().m_216339_(30, 60))));
    }

    @Override
    public BrainActivityGroup<SBLSkeleton> getFightTasks() {
        return BrainActivityGroup.fightTasks(new InvalidateAttackTarget(), new FirstApplicableBehaviour(new BowAttack<SBLSkeleton>(20).startCondition(SBLSkeleton::isHoldingBow), new AnimatableMeleeAttack<Mob>(0).whenStarting(entity -> this.m_21561_(true)).whenStarting(entity -> this.m_21561_(false))));
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
    }

    private static boolean isHoldingBow(LivingEntity livingEntity) {
        return livingEntity.m_21093_(stack -> stack.m_41720_() instanceof BowItem);
    }
}

