/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.sensor.vanilla;

import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.api.core.sensor.PredicateSensor;
import com.klikli_dev.forgebrainlib.object.SquareRadius;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.klikli_dev.forgebrainlib.util.EntityRetrievalUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NearbyLivingEntitySensor<E extends LivingEntity>
extends PredicateSensor<LivingEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_148204_, MemoryModuleType.f_148205_});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyLivingEntitySensor() {
        super((target, entity) -> target != entity && target.m_6084_());
    }

    public NearbyLivingEntitySensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyLivingEntitySensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_LIVING_ENTITY.get();
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.m_21133_(Attributes.f_22277_);
            radius = new SquareRadius(dist, dist);
        }
        List entities = EntityRetrievalUtil.getEntities((Level)level, entity.m_20191_().m_82377_(radius.xzRadius(), radius.yRadius(), radius.xzRadius()), obj -> {
            if (!(obj instanceof LivingEntity)) return false;
            LivingEntity livingEntity = (LivingEntity)obj;
            if (!this.predicate().test(livingEntity, entity)) return false;
            return true;
        });
        entities.sort(Comparator.comparingDouble(arg_0 -> entity.m_20280_(arg_0)));
        BrainUtils.setMemory(entity, MemoryModuleType.f_148204_, entities);
        BrainUtils.setMemory(entity, MemoryModuleType.f_148205_, new NearestVisibleLivingEntities(entity, entities));
    }
}

