/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.sensor.vanilla;

import com.klikli_dev.forgebrainlib.api.core.sensor.EntityFilteringSensor;
import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import org.jetbrains.annotations.Nullable;

public class NearbyHostileSensor<E extends LivingEntity>
extends EntityFilteringSensor<LivingEntity, E> {
    private final Map<EntityType<?>, Float> hostileDistanceMap = new Object2FloatOpenHashMap(11);

    public NearbyHostileSensor() {
        this.setHostiles(Pair.of((Object)EntityType.f_20562_, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.f_20458_, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.f_20491_, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.f_20501_, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.f_20530_, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.f_20493_, (Object)Float.valueOf(10.0f)), Pair.of((Object)EntityType.f_20500_, (Object)Float.valueOf(10.0f)), Pair.of((Object)EntityType.f_20568_, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.f_20459_, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.f_20518_, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.f_20513_, (Object)Float.valueOf(15.0f)));
    }

    public NearbyHostileSensor<E> setHostiles(Pair<EntityType<?>, Float> ... entries) {
        this.hostileDistanceMap.clear();
        for (Pair<EntityType<?>, Float> entry : entries) {
            this.hostileDistanceMap.put((EntityType)entry.getFirst(), (Float)entry.getSecond());
        }
        return this;
    }

    public NearbyHostileSensor<E> addHostile(Pair<EntityType<?>, Float> entry) {
        this.hostileDistanceMap.put((EntityType)entry.getFirst(), (Float)entry.getSecond());
        return this;
    }

    @Override
    public MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.f_26323_;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_HOSTILE.get();
    }

    @Override
    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, entity) -> {
            Float distance = this.hostileDistanceMap.get(target.m_6095_());
            return distance != null && target.m_20280_((Entity)entity) <= (double)(distance.floatValue() * distance.floatValue());
        };
    }

    @Override
    @Nullable
    protected LivingEntity findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return matcher.m_186116_(target -> this.predicate().test((LivingEntity)target, entity)).orElse(null);
    }
}

