/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.sensor.vanilla;

import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.api.core.sensor.PredicateSensor;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;

public class NearbyGolemSensor<E extends LivingEntity>
extends PredicateSensor<LivingEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26327_});
    private int timeToRemember = 600;

    public NearbyGolemSensor() {
        this.setScanRate((T entity) -> 200);
        this.setPredicate((target, entity) -> target.m_6095_() == EntityType.f_20460_ && target.m_6084_());
    }

    public NearbyGolemSensor<E> setMemoryTime(int ticks) {
        this.timeToRemember = ticks;
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_GOLEM.get();
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        BrainUtils.withMemory(entity, MemoryModuleType.f_148204_, entityList -> {
            if (entityList.isEmpty()) {
                return;
            }
            for (LivingEntity target : entityList) {
                if (!this.predicate().test(target, entity)) continue;
                BrainUtils.setForgettableMemory(entity, MemoryModuleType.f_26327_, Boolean.valueOf(true), this.timeToRemember);
                return;
            }
        });
    }
}

