/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.sensor.vanilla;

import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.api.core.sensor.PredicateSensor;
import com.klikli_dev.forgebrainlib.object.SquareRadius;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.klikli_dev.forgebrainlib.util.EntityRetrievalUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemTemptingSensor<E extends LivingEntity>
extends PredicateSensor<Player, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_148196_});
    protected Ingredient temptingItems = Ingredient.f_43901_;
    protected SquareRadius radius = new SquareRadius(10.0, 10.0);

    public ItemTemptingSensor() {
        this.setPredicate((target, entity) -> {
            if (target.m_5833_() || !target.m_6084_()) {
                return false;
            }
            return this.temptingItems.test(target.m_21205_()) || this.temptingItems.test(target.m_21206_());
        });
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.ITEM_TEMPTING.get();
    }

    public ItemTemptingSensor<E> setTemptingItems(Ingredient temptingItems) {
        this.temptingItems = temptingItems;
        return this;
    }

    public ItemTemptingSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public ItemTemptingSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.f_148196_, EntityRetrievalUtil.getNearestPlayer(entity, this.radius.xzRadius(), this.radius.yRadius(), this.radius.xzRadius(), target -> this.predicate().test(target, entity)));
    }
}

