/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.sensor.vanilla;

import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;

public class HoglinSpecificSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26350_, MemoryModuleType.f_26348_, MemoryModuleType.f_26352_, MemoryModuleType.f_26353_, MemoryModuleType.f_26356_});

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.HOGLIN_SPECIFIC.get();
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        Brain brain = entity.m_6274_();
        BrainUtils.withMemory(brain, MemoryModuleType.f_148205_, entities -> {
            int piglinCount = 0;
            Piglin nearestPiglin = null;
            ObjectArrayList hoglins = new ObjectArrayList();
            for (LivingEntity target : entities.m_186123_(mob -> !mob.m_6162_())) {
                if (target instanceof Piglin) {
                    Piglin piglin = (Piglin)target;
                    ++piglinCount;
                    if (nearestPiglin != null) continue;
                    nearestPiglin = piglin;
                    continue;
                }
                if (!(target instanceof Hoglin)) continue;
                Hoglin hoglin = (Hoglin)target;
                hoglins.add(hoglin);
            }
            BrainUtils.setMemory(brain, MemoryModuleType.f_26350_, nearestPiglin);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26348_, hoglins);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26352_, Integer.valueOf(piglinCount));
            BrainUtils.setMemory(brain, MemoryModuleType.f_26353_, Integer.valueOf(hoglins.size()));
            BrainUtils.setMemory(brain, MemoryModuleType.f_26356_, (BlockPos)BlockPos.m_121930_((BlockPos)entity.m_20183_(), (int)8, (int)4, pos -> level.m_8055_(pos).m_204336_(BlockTags.f_13084_)).orElse(null));
        });
    }
}

