/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.sensor.custom;

import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.registry.SBLMemoryTypes;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;

public class UnreachableTargetSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26326_, MemoryModuleType.f_26372_, SBLMemoryTypes.TARGET_UNREACHABLE.get()});
    private long lastUnpathableTime = 0L;

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.UNREACHABLE_TARGET.get();
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        Brain brain = entity.m_6274_();
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            this.resetState(brain);
            return;
        }
        Long unpathableTime = (Long)BrainUtils.getMemory(brain, MemoryModuleType.f_26326_);
        if (unpathableTime == null) {
            this.resetState(brain);
            return;
        }
        if (this.lastUnpathableTime == 0L) {
            this.lastUnpathableTime = unpathableTime;
        } else if (this.lastUnpathableTime == unpathableTime) {
            BrainUtils.clearMemory(brain, SBLMemoryTypes.TARGET_UNREACHABLE.get());
        } else if (this.lastUnpathableTime < unpathableTime) {
            this.lastUnpathableTime = unpathableTime;
            BrainUtils.setMemory(brain, SBLMemoryTypes.TARGET_UNREACHABLE.get(), Boolean.valueOf(target.m_20186_() > entity.m_20188_()));
        }
    }

    private void resetState(Brain<?> brain) {
        if (this.lastUnpathableTime > 0L) {
            BrainUtils.clearMemory(brain, SBLMemoryTypes.TARGET_UNREACHABLE.get());
        }
        this.lastUnpathableTime = 0L;
    }
}

