/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.sensor.custom;

import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.api.core.sensor.PredicateSensor;
import com.klikli_dev.forgebrainlib.registry.SBLMemoryTypes;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.klikli_dev.forgebrainlib.util.EntityRetrievalUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class IncomingProjectilesSensor<E extends LivingEntity>
extends PredicateSensor<Projectile, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{SBLMemoryTypes.INCOMING_PROJECTILES.get()});

    public IncomingProjectilesSensor() {
        this.setScanRate((T entity) -> 3);
        this.setPredicate((projectile, entity) -> {
            if (projectile.m_20096_() || projectile.f_19862_ || projectile.f_19863_) {
                return false;
            }
            return entity.m_20191_().m_82371_(projectile.m_20182_(), projectile.m_20182_().m_82549_(projectile.m_20184_().m_82542_(3.0, 3.0, 3.0))).isPresent();
        });
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.INCOMING_PROJECTILES.get();
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        List projectiles = EntityRetrievalUtil.getEntities((Level)level, entity.m_20191_().m_82400_(7.0), target -> {
            if (!(target instanceof Projectile)) return false;
            Projectile projectile = (Projectile)target;
            if (!this.predicate().test(projectile, entity)) return false;
            return true;
        });
        if (!projectiles.isEmpty()) {
            projectiles.sort(Comparator.comparingDouble(arg_0 -> entity.m_20280_(arg_0)));
            BrainUtils.setMemory(entity, SBLMemoryTypes.INCOMING_PROJECTILES.get(), projectiles);
        } else {
            BrainUtils.clearMemory(entity, SBLMemoryTypes.INCOMING_PROJECTILES.get());
        }
    }
}

