/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.behaviour.custom.target;

import com.klikli_dev.forgebrainlib.api.core.behaviour.ExtendedBehaviour;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;

public class TargetOrRetaliate<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_26381_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148194_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.REGISTERED)});
    protected Predicate<LivingEntity> canAttackPredicate = entity -> {
        Player player;
        return entity.m_6084_() && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_());
    };
    protected LivingEntity toTarget = null;
    protected MemoryModuleType<? extends LivingEntity> priorityTargetMemory = MemoryModuleType.f_148194_;

    public TargetOrRetaliate<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> useMemory(MemoryModuleType<? extends LivingEntity> memory) {
        this.priorityTargetMemory = memory;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E owner) {
        Brain brain = owner.m_6274_();
        this.toTarget = BrainUtils.getMemory(brain, this.priorityTargetMemory);
        if (this.toTarget == null) {
            this.toTarget = (LivingEntity)BrainUtils.getMemory(brain, MemoryModuleType.f_26382_);
        }
        if (this.toTarget == null) {
            NearestVisibleLivingEntities nearbyEntities = (NearestVisibleLivingEntities)BrainUtils.getMemory(brain, MemoryModuleType.f_148205_);
            if (nearbyEntities != null) {
                this.toTarget = nearbyEntities.m_186116_(this.canAttackPredicate).orElse(null);
            }
            if (this.toTarget != null) {
                return true;
            }
        }
        return this.toTarget != null && this.canAttackPredicate.test(this.toTarget);
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setTargetOfEntity(entity, this.toTarget);
        BrainUtils.clearMemory(entity, MemoryModuleType.f_26326_);
        this.toTarget = null;
    }
}

