/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.behaviour.custom.target;

import com.klikli_dev.forgebrainlib.api.core.behaviour.ExtendedBehaviour;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class SetAttackTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_148194_, (Object)MemoryStatus.VALUE_PRESENT)});
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> CUSTOM_TARGETING_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected final boolean usingNearestAttackable;
    protected Predicate<E> canAttackPredicate = entity -> true;
    protected Function<E, ? extends LivingEntity> targetFinder = entity -> (LivingEntity)BrainUtils.getMemory(entity, MemoryModuleType.f_148194_);

    public SetAttackTarget() {
        this(true);
    }

    public SetAttackTarget(boolean usingNearestAttackable) {
        this.usingNearestAttackable = usingNearestAttackable;
    }

    public SetAttackTarget<E> attackPredicate(Predicate<E> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public SetAttackTarget<E> targetFinder(Function<E, ? extends LivingEntity> targetFindingFunction) {
        this.targetFinder = targetFindingFunction;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return this.usingNearestAttackable ? MEMORY_REQUIREMENTS : CUSTOM_TARGETING_REQUIREMENTS;
    }

    @Override
    protected boolean m_6114_(ServerLevel level, E entity) {
        return this.canAttackPredicate.test(entity);
    }

    @Override
    protected void start(E entity) {
        LivingEntity target = this.targetFinder.apply(entity);
        if (target == null) {
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26372_);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.f_26372_, target);
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26326_);
        }
    }
}

