/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.behaviour.custom.move;

import com.klikli_dev.forgebrainlib.api.core.behaviour.ExtendedBehaviour;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MoveToWalkTarget<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26377_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_PRESENT)});
    @Nullable
    protected Path path;
    @Nullable
    protected BlockPos lastTargetPos;
    protected float speedModifier;

    public MoveToWalkTarget() {
        this.runFor(entity -> entity.m_217043_().m_188503_(100) + 150);
        this.cooldownFor(entity -> entity.m_217043_().m_188503_(40));
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Brain brain = entity.m_6274_();
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory(brain, MemoryModuleType.f_26370_);
        if (!this.hasReachedTarget(entity, walkTarget) && this.attemptNewPath(entity, walkTarget, false)) {
            this.lastTargetPos = walkTarget.m_26420_().m_6675_();
            return true;
        }
        BrainUtils.clearMemory(brain, MemoryModuleType.f_26370_);
        BrainUtils.clearMemory(brain, MemoryModuleType.f_26326_);
        return false;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        if (this.path == null || this.lastTargetPos == null) {
            return false;
        }
        if (entity.m_21573_().m_26571_()) {
            return false;
        }
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory(entity, MemoryModuleType.f_26370_);
        return walkTarget != null && !this.hasReachedTarget(entity, walkTarget);
    }

    @Override
    protected void start(E entity) {
        this.startOnNewPath(entity);
    }

    @Override
    protected void tick(E entity) {
        WalkTarget walkTarget;
        Path path = entity.m_21573_().m_26570_();
        Brain brain = entity.m_6274_();
        if (this.path != path) {
            this.path = path;
            BrainUtils.setMemory(brain, MemoryModuleType.f_26377_, path);
        }
        if (path != null && this.lastTargetPos != null && (walkTarget = (WalkTarget)BrainUtils.getMemory(brain, MemoryModuleType.f_26370_)).m_26420_().m_6675_().m_123331_((Vec3i)this.lastTargetPos) > 4.0 && this.attemptNewPath(entity, walkTarget, this.hasReachedTarget(entity, walkTarget))) {
            this.lastTargetPos = walkTarget.m_26420_().m_6675_();
            this.startOnNewPath(entity);
        }
    }

    @Override
    protected void stop(E entity) {
        Brain brain = entity.m_6274_();
        if (!entity.m_21573_().m_26577_() || !BrainUtils.hasMemory(brain, MemoryModuleType.f_26370_) || this.hasReachedTarget(entity, (WalkTarget)BrainUtils.getMemory(brain, MemoryModuleType.f_26370_))) {
            this.cooldownFinishedAt = 0L;
        }
        entity.m_21573_().m_26573_();
        BrainUtils.clearMemories(brain, MemoryModuleType.f_26370_, MemoryModuleType.f_26377_);
        this.path = null;
    }

    protected boolean attemptNewPath(E entity, WalkTarget walkTarget, boolean reachedCurrentTarget) {
        Brain brain = entity.m_6274_();
        BlockPos pos = walkTarget.m_26420_().m_6675_();
        this.path = entity.m_21573_().m_7864_(pos, 0);
        this.speedModifier = walkTarget.m_26421_();
        if (reachedCurrentTarget) {
            BrainUtils.clearMemory(brain, MemoryModuleType.f_26326_);
            return false;
        }
        if (this.path != null && this.path.m_77403_()) {
            BrainUtils.clearMemory(brain, MemoryModuleType.f_26326_);
        } else {
            BrainUtils.setMemory(brain, MemoryModuleType.f_26326_, Long.valueOf(((PathfinderMob)entity).f_19853_.m_46467_()));
        }
        if (this.path != null) {
            return true;
        }
        Vec3 newTargetPos = DefaultRandomPos.m_148412_(entity, (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)pos), (double)1.5707963705062866);
        if (newTargetPos != null) {
            this.path = entity.m_21573_().m_26524_(newTargetPos.m_7096_(), newTargetPos.m_7098_(), newTargetPos.m_7094_(), 0);
            return this.path != null;
        }
        return false;
    }

    protected boolean hasReachedTarget(E entity, WalkTarget target) {
        return target.m_26420_().m_6675_().m_123333_((Vec3i)entity.m_20183_()) <= target.m_26422_();
    }

    protected void startOnNewPath(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.f_26377_, this.path);
        entity.m_21573_().m_26536_(this.path, (double)this.speedModifier);
    }
}

