/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.behaviour.custom.misc;

import com.klikli_dev.forgebrainlib.api.core.behaviour.ExtendedBehaviour;
import com.klikli_dev.forgebrainlib.object.TriPredicate;
import com.klikli_dev.forgebrainlib.registry.SBLMemoryTypes;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;

public class BreakBlock<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(SBLMemoryTypes.NEARBY_BLOCKS.get(), (Object)MemoryStatus.VALUE_PRESENT)});
    protected TriPredicate<E, BlockPos, BlockState> targetBlockPredicate = (entity, pos, state) -> state.m_204336_(BlockTags.f_13103_);
    protected TriPredicate<E, BlockPos, BlockState> stopPredicate = (entity, pos, state) -> false;
    protected TriFunction<E, BlockPos, BlockState, Integer> digTimePredicate = (entity, pos, state) -> 240;
    protected BlockPos pos = null;
    protected BlockState state = null;
    protected int timeToBreak = 0;
    protected int breakTime = 0;
    protected int breakProgress = -1;

    public BreakBlock<E> stopBreakingIf(TriPredicate<E, BlockPos, BlockState> predicate) {
        this.stopPredicate = predicate;
        return this;
    }

    public BreakBlock<E> forBlocks(TriPredicate<E, BlockPos, BlockState> predicate) {
        this.targetBlockPredicate = predicate;
        return this;
    }

    public BreakBlock<E> timeToBreak(TriFunction<E, BlockPos, BlockState, Integer> function) {
        this.digTimePredicate = function;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean m_7773_(long gameTime) {
        return this.breakProgress < 0 && super.m_7773_(gameTime);
    }

    @Override
    protected void stop(E entity) {
        ((LivingEntity)entity).f_19853_.m_6801_(entity.m_19879_(), this.pos, -1);
        this.state = null;
        this.pos = null;
        this.timeToBreak = 0;
        this.breakTime = 0;
        this.breakProgress = -1;
    }

    @Override
    protected boolean m_6114_(ServerLevel level, E entity) {
        for (Pair<BlockPos, BlockState> pair : BrainUtils.getMemory(entity, SBLMemoryTypes.NEARBY_BLOCKS.get())) {
            if (!this.targetBlockPredicate.test(entity, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond())) continue;
            this.pos = (BlockPos)pair.getFirst();
            this.state = (BlockState)pair.getSecond();
            this.timeToBreak = (Integer)this.digTimePredicate.apply(entity, (Object)this.pos, (Object)this.state);
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return ((LivingEntity)entity).f_19853_.m_46467_() <= (long)this.breakTime && this.targetBlockPredicate.test(entity, this.pos, ((LivingEntity)entity).f_19853_.m_8055_(this.pos)) && !this.stopPredicate.test(entity, this.pos, this.state);
    }

    @Override
    protected void tick(E entity) {
        ++this.breakTime;
        int progress = (int)((float)this.breakTime / (float)this.timeToBreak * 10.0f);
        if (progress != this.breakProgress) {
            ((LivingEntity)entity).f_19853_.m_6801_(entity.m_19879_(), this.pos, progress);
            this.breakProgress = progress;
        }
        if (this.breakTime >= this.timeToBreak) {
            ((LivingEntity)entity).f_19853_.m_7471_(this.pos, false);
            ((LivingEntity)entity).f_19853_.m_46796_(2001, this.pos, Block.m_49956_((BlockState)((LivingEntity)entity).f_19853_.m_8055_(this.pos)));
            this.m_22562_((ServerLevel)((LivingEntity)entity).f_19853_, (LivingEntity)entity, ((LivingEntity)entity).f_19853_.m_46467_());
        }
    }
}

