/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api.core.behaviour.custom.attack;

import com.klikli_dev.forgebrainlib.api.core.behaviour.DelayedBehaviour;
import com.klikli_dev.forgebrainlib.util.BrainUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.RangedAttackMob;
import org.jetbrains.annotations.Nullable;

public class AnimatableRangedAttack<E extends LivingEntity>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected Function<E, Integer> attackIntervalSupplier = entity -> entity.f_19853_.m_46791_() == Difficulty.HARD ? 20 : 40;
    protected float attackRadius;
    @Nullable
    protected LivingEntity target = null;

    public AnimatableRangedAttack(int delayTicks) {
        super(delayTicks);
        this.attackRadius(16.0f);
    }

    public AnimatableRangedAttack<E> attackInterval(Function<E, Integer> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    public AnimatableRangedAttack<E> attackRadius(float radius) {
        this.attackRadius = radius * radius;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean m_6114_(ServerLevel level, E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        return BrainUtils.canSee(entity, this.target) && entity.m_20280_((Entity)this.target) <= (double)this.attackRadius;
    }

    @Override
    protected void start(E entity) {
        entity.m_6674_(InteractionHand.MAIN_HAND);
        BehaviorUtils.m_22595_(entity, (LivingEntity)this.target);
    }

    @Override
    protected void stop(E entity) {
        this.target = null;
    }

    @Override
    protected void doDelayedAction(E entity) {
        if (this.target == null) {
            return;
        }
        if (!BrainUtils.canSee(entity, this.target) || entity.m_20280_((Entity)this.target) > (double)this.attackRadius) {
            return;
        }
        ((RangedAttackMob)entity).m_6504_(this.target, 1.0f);
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.f_26373_, Boolean.valueOf(true), (int)this.attackIntervalSupplier.apply(entity));
    }
}

