/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib.api;

import com.google.common.collect.ImmutableSet;
import com.klikli_dev.forgebrainlib.api.core.BrainActivityGroup;
import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.schedule.Activity;

public interface SmartBrainOwner<T extends LivingEntity> {
    public List<ExtendedSensor<T>> getSensors();

    default public BrainActivityGroup<T> getCoreTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<T> getIdleTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<T> getFightTasks() {
        return BrainActivityGroup.empty();
    }

    default public Map<Activity, BrainActivityGroup<T>> getAdditionalTasks() {
        return new Object2ObjectOpenHashMap(0);
    }

    default public Set<Activity> getAlwaysRunningActivities() {
        return ImmutableSet.of((Object)Activity.f_37978_);
    }

    default public Activity getDefaultActivity() {
        return Activity.f_37979_;
    }

    default public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{Activity.f_37988_, Activity.f_37979_});
    }

    default public void handleAdditionalBrainSetup(Brain<T> brain) {
    }

    default public void tickBrain(T entity) {
        entity.m_6274_().m_21865_((ServerLevel)entity.m_9236_(), entity);
    }
}

