/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.forgebrainlib;

import com.klikli_dev.forgebrainlib.SBLLoader;
import com.klikli_dev.forgebrainlib.api.core.sensor.ExtendedSensor;
import com.klikli_dev.forgebrainlib.example.boilerplate.SBLExampleEntities;
import com.klikli_dev.forgebrainlib.registry.SBLMemoryTypes;
import com.klikli_dev.forgebrainlib.registry.SBLSensors;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class SBLForge
implements SBLLoader {
    public static final DeferredRegister<MemoryModuleType<?>> MEMORY_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.MEMORY_MODULE_TYPES, (String)"forgebrainlib");
    public static final DeferredRegister<SensorType<?>> SENSORS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.SENSOR_TYPES, (String)"forgebrainlib");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (String)"forgebrainlib");

    @Override
    public void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MEMORY_TYPES.register(modEventBus);
        SENSORS.register(modEventBus);
        SBLMemoryTypes.init();
        SBLSensors.init();
        if (this.isDevEnv()) {
            ENTITY_TYPES.register(modEventBus);
            modEventBus.addListener(EventPriority.NORMAL, false, EntityAttributeCreationEvent.class, SBLForge::registerEntityStats);
            SBLExampleEntities.init();
        }
    }

    @Override
    public boolean isDevEnv() {
        return !FMLLoader.isProduction();
    }

    @Override
    public <T> Supplier<MemoryModuleType<T>> registerMemoryType(String id) {
        return this.registerMemoryType(id, null);
    }

    @Override
    public <T> Supplier<MemoryModuleType<T>> registerMemoryType(String id, @Nullable Codec<T> codec) {
        return MEMORY_TYPES.register(id, () -> new MemoryModuleType(Optional.ofNullable(codec)));
    }

    @Override
    public <T extends ExtendedSensor<?>> Supplier<SensorType<T>> registerSensorType(String id, Supplier<T> sensor) {
        return SENSORS.register(id, () -> new SensorType(sensor));
    }

    @Override
    public <T extends LivingEntity> Supplier<EntityType<T>> registerEntityType(String id, Supplier<EntityType<T>> entityType) {
        return ENTITY_TYPES.register(id, entityType);
    }

    private static void registerEntityStats(EntityAttributeCreationEvent ev) {
        ev.put(SBLExampleEntities.SBL_SKELETON.get(), Skeleton.m_32166_().m_22265_());
    }
}

