/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobilePrefab;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import java.text.DecimalFormat;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public final class AUtils
extends Enum<AUtils> {
    public static final DecimalFormat DEC_TWO_PLACES;
    public static final Direction[] HORIZONTAL_DIRS;
    public static boolean IGNORE_ENTITY_GROUND_CHECK_STEPPING;
    private static final RandomSource RANDOM;
    private static final /* synthetic */ AUtils[] $VALUES;

    public static AUtils[] values() {
        return (AUtils[])$VALUES.clone();
    }

    public static AUtils valueOf(String name) {
        return Enum.valueOf(AUtils.class, name);
    }

    public static float zero(float in, float by) {
        return AUtils.shift(in, by, 0.0f);
    }

    public static int zero(int in, int by) {
        return AUtils.shift(in, by, 0);
    }

    public static float shift(float in, float by, float to) {
        if (Math.abs(in - to) < by) {
            return to;
        }
        if (in > to) {
            by *= -1.0f;
        }
        return in += by;
    }

    public static int shift(int in, int by, int to) {
        if (Math.abs(in - to) < by) {
            return to;
        }
        if (in > to) {
            by *= -1;
        }
        return in += by;
    }

    public static boolean haveSameSign(float a, float b) {
        if (a == 0.0f || b == 0.0f) {
            return a == b;
        }
        return a / Math.abs(a) == b / Math.abs(b);
    }

    public static float furthestFromZero(float a, float b) {
        return Math.abs(a) > Math.abs(b) ? a : (Math.abs(b) > Math.abs(a) ? b : a);
    }

    public static CompoundTag v3dToNbt(Vec3 vec) {
        CompoundTag r = new CompoundTag();
        r.m_128347_("x", vec.m_7096_());
        r.m_128347_("y", vec.m_7098_());
        r.m_128347_("z", vec.m_7094_());
        return r;
    }

    public static Vec3 v3dFromNbt(CompoundTag nbt) {
        return new Vec3(nbt.m_128459_("x"), nbt.m_128459_("y"), nbt.m_128459_("z"));
    }

    public static void renderMyronObj(BakedModel model, VertexConsumer vertices, PoseStack matrices, int light, int overlay) {
        try {
            for (BakedQuad quad : model.m_213637_(null, null, RANDOM)) {
                vertices.m_85987_(matrices.m_85850_(), quad, 1.0f, 1.0f, 1.0f, light, overlay);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static Vector3f colorFromInt(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static boolean canMerge(ItemStack a, ItemStack b) {
        return a.m_41726_(b) && a.m_41613_() + b.m_41613_() <= a.m_41741_();
    }

    public static boolean transferInto(ItemStack stack, Container inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            if (!inv.m_7013_(slot, stack)) continue;
            ItemStack slotStack = inv.m_8020_(slot);
            if (slotStack.m_41619_()) {
                inv.m_6836_(slot, stack);
                return true;
            }
            if (!AUtils.canMerge(slotStack, stack)) continue;
            int amount = Math.min(stack.m_41613_(), stack.m_41741_() - slotStack.m_41613_());
            stack.m_41774_(amount);
            slotStack.m_41769_(amount);
            return stack.m_41619_();
        }
        return false;
    }

    public static ItemStack createGroupIcon() {
        return new ItemStack((ItemLike)AutomobilityItems.CROWBAR.require());
    }

    public static ItemStack createPrefabsIcon() {
        return new AutomobilePrefab(Automobility.rl("standard_light_blue"), AutomobileFrame.STANDARD_LIGHT_BLUE, AutomobileWheel.STANDARD, AutomobileEngine.IRON).toStack();
    }

    private static /* synthetic */ AUtils[] $values() {
        return new AUtils[0];
    }

    static {
        $VALUES = AUtils.$values();
        DEC_TWO_PLACES = new DecimalFormat("###0.00");
        HORIZONTAL_DIRS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        IGNORE_ENTITY_GROUND_CHECK_STEPPING = false;
        RANDOM = RandomSource.m_216327_();
    }
}

