/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DashPanelBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE = DashPanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public DashPanelBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, LEFT, RIGHT, POWERED, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60713_(Blocks.f_49990_)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockState lState = world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_175364_(Direction.Axis.Y)));
        BlockState rState = world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_175362_(Direction.Axis.Y)));
        boolean left = lState.m_60713_((Block)this) && lState.m_61143_((Property)POWERED) == state.m_61143_((Property)POWERED);
        boolean right = rState.m_60713_((Block)this) && rState.m_61143_((Property)POWERED) == state.m_61143_((Property)POWERED);
        return (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, level, pos, block, fromPos, notify);
        boolean levelPwr = level.m_46753_(pos);
        boolean selfPwr = (Boolean)state.m_61143_((Property)POWERED);
        if (levelPwr != selfPwr) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(levelPwr)));
        }
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        DashPanelBlock.onCollideWithDashPanel(state, entity);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public static void onCollideWithDashPanel(@Nullable BlockState panelState, Entity entity) {
        if (panelState != null && ((Boolean)panelState.m_61143_((Property)POWERED)).booleanValue()) {
            return;
        }
        if (entity instanceof AutomobileEntity) {
            AutomobileEntity auto = (AutomobileEntity)entity;
            auto.boost(0.45f, 50);
        } else if (entity.m_6095_().m_204039_(AutomobilityEntities.DASH_PANEL_BOOSTABLES)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 6, true, false, false));
            }
            double yaw = Math.toRadians(-entity.m_146908_());
            Vec3 vel = new Vec3(Math.sin(yaw), 0.0, Math.cos(yaw));
            entity.m_5997_(vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }
}

