/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment;

import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class BaseAttachment<T extends AutomobileComponent<T>> {
    public final T type;
    protected final AutomobileEntity automobile;
    private float animation;

    public BaseAttachment(T type, AutomobileEntity automobile) {
        this.type = type;
        this.automobile = automobile;
    }

    public final AutomobileEntity automobile() {
        return this.automobile;
    }

    protected final Level world() {
        return this.automobile.f_19853_;
    }

    public abstract Vec3 pos();

    public float animation() {
        return this.animation;
    }

    public void setAnimation(float animation) {
        this.animation = animation;
    }

    protected abstract void updateTrackedAnimation(float var1);

    public void onTrackedAnimationUpdated(float animation) {
        this.setAnimation(animation);
    }

    public void tick() {
    }

    public void onRemoved() {
    }

    public abstract void writeNbt(CompoundTag var1);

    public abstract void readNbt(CompoundTag var1);

    public void updatePacketRequested(ServerPlayer player) {
    }

    protected boolean canModifyBlocks() {
        Player player;
        Entity entity = this.automobile.m_146895_();
        if (entity instanceof Player && (player = (Player)entity).m_36326_()) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (!this.world().m_8055_(this.automobile.m_20183_().m_6625_(i)).m_60713_(AutomobilityBlocks.ALLOW.require())) continue;
            return true;
        }
        return false;
    }

    public final CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", this.type.getId().toString());
        this.writeNbt(nbt);
        return nbt;
    }
}

